/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.customise.ActorInfo;
import com.sinaflying.customise.Function;
import com.sinaflying.customise.R;
import com.sinaflying.database.DataTable;
import com.sinaflying.database.GameDB;
import com.sinaflying.engine.Avatar;
import com.sinaflying.engine.KeyCode;
import com.sinaflying.engine.ResourceManager;
import com.sinaflying.engine.TiledBackground;
import com.sinaflying.game.Actor;
import com.sinaflying.game.Bomb;
import com.sinaflying.game.GameInterface;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.GameMessageBox;
import com.sinaflying.game.GameRoleData;
import com.sinaflying.game.MainActor;
import com.sinaflying.game.MessageBoxHandler;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.game.SceneUI;
import com.sinaflying.s2nparser.IS2nExecutor;
import com.sinaflying.s2nparser.S2nParser;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class Scene
implements IS2nExecutor,
MessageBoxHandler {
    private static Scene _instance;
    private static Actor _focus;
    private static DataInputStream _is;
    public static ResourceManager _resource;
    private GameMainLogic _gic;
    public TiledBackground _bk;
    private static int _types;
    private static byte[][] _typesLoad;
    private static byte _globalActorNum;
    private static byte[] _globalActorId;
    private int _sectorNum;
    private int _sectorWidth;
    private int _sectorHeight;
    private int _curSector;
    private int _frame;
    public static String _resultString;
    private int _winCurIndex;
    private int _winCurLevelNum;
    private static byte[][] _sectorCaptorId;
    private static byte[][] _sectorActorId;
    private static byte[][] _captorInitData;
    private static boolean[] _captorInstTriged;
    private static boolean[] _captorInstCheckin;
    private static int _staticActorNum;
    public static Actor[] _activeInsts;
    private static Actor[] _insts;
    public static byte[][] _actorInitData;
    private static boolean[] _actorInstInited;
    private static Actor[][] _actorPool;
    public static int _camx;
    public static int _camy;
    private static int _camvx;
    private static int _camvy;
    public static int _camw;
    public static int _camh;
    public static int _preCamX;
    public static int _preCamY;
    public int _lockCameraXpos;
    public int _lockCameraYpos;
    private boolean _isLockedCamera;
    private static byte produceProcess;
    protected static byte _level;
    protected static byte _state;
    private static int _bombState;
    public int _shakeTime;
    public int _shakeRange;
    public int _cameraOffsetX;
    public int _cameraOffsetY;
    private int _pressKey = -1;
    private int _moveValue = -1;
    private boolean _openShop;
    private boolean _openTeach;
    private boolean _openSceneTeach;
    private boolean _openFace;
    private int _openFaceX;
    private int _openFaceY;
    private int _openFaceId;
    public static boolean _isInCity;
    public static int[][] _actorExistFlag;
    public static MainActor[] _mainActor;
    private GameMessageBox _messageBox;
    private int _camX;
    private int _camY;
    private int _bufferCamX;
    private int _bufferCamY;
    private boolean _openMoveSceen = false;
    private boolean _openMoveFlag = false;
    private boolean _openMoveSceenFlag = false;
    private int _openFlagAction;
    private int _openFlagX;
    private int _openFlagY;
    public static boolean isAllEnd;
    public int _lastTeam;
    public int _nextEnemy;
    private static final int[][] MOVE_SCEEN_DATA;
    private static final int[][] MOVE_SCEEN_ACTION;
    public String[] _nextSceneName = new String[]{"", "", "\u0110\u00f4ng Th\u00f4n Gi\u00f3", "C\u1eeda Th\u00f4n Gi\u00f3", "C\u1eeda T\u00e2y Th\u00f4n Gi\u00f3", "T\u00e2y Th\u00f4n Gi\u00f3", "C\u1eeda R\u1eebng", "Bi\u1ec3n Hoa", "R\u1eebng L\u00e1", "R\u1eebng Bay", "\u0110\u01b0\u1eddng C\u1ee5t", "V\u00f9ng C\u00e2y B\u1ee5i", "R\u1eebng C\u00e2y B\u1ee5i", "S\u00e2u Trong R\u1eebng C\u00e2y B\u1ee5i", "Bi\u1ec3n C\u1ea1n", "Bi\u1ec3n C\u1ea1n 2", "Bi\u1ec3n C\u1ea1n 3", "B\u1edd Bi\u1ec3n \u0110\u00f4ng", "B\u1edd Bi\u1ec3n \u0110\u00f4ng 2", "B\u1edd Bi\u1ec3n \u0110\u00f4ng 3", "Bi\u1ec3n Vi\u1ec3n C\u1ed5", "B\u1edd Bi\u1ec3n C\u1ed5", "\u0110\u1ed9ng L\u1eef Nh\u00e2n", "\u0110\u1ed9ng L\u1eef Nh\u00e2n 2", "Trong \u0110\u1ed9ng L\u1eef nh\u00e2n", "\u0110\u1ed9ng L\u1edbn", "\u0110\u1ed9ng L\u1edbn 2", "\u0110\u1ed9ng L\u1edbn 3", "\u0110\u1ed9ng \u0110en C\u1eadn \u0110\u00e1y", "\u0110\u1ed9ng \u0110en N\u01a1i S\u00e2u Nh\u1ea5t", "L\u1ed1i V\u00e0o V\u00f9ng \u0110\u1ea5t Cao", "V\u00f9ng \u0110\u1ea5t Cao", "V\u00f9ng \u0110\u1ea5t Cao 2", "H\u00e0nh Lang G\u1ea5p Kh\u00fac", "H\u00e0nh Lang G\u1ea5p Kh\u00fac 2", "H\u00e0nh Lang G\u1ea5p Kh\u00fac 3", "C\u1eeda V\u00e0o M\u1ed9 \u0110\u1ecba", "M\u1ed9 H\u1eafc Long", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    private boolean _isReadRMS;
    public boolean _isChangetoNewScene;
    public int _enterNewSceneTime = 0;
    private int sceneColor;
    private String sceneName;
    Bomb fire = null;
    public int _inState;
    public int _once;
    private static final int[][] TOUCH_SCEEN_KEY;
    private static final int[][] TOUCH_KEY_DATA;
    public static int _tankNum;
    public static int _tankOneTeamNum;
    public static int _tankTwoTeamNum;
    private S2nParser _parser;
    public static byte[] _scriptSave;
    public static int _camDestx;
    public static int _camDesty;
    private static byte[] _newIds;
    private static int _activeNum;
    public static Avatar[] _anims;
    public static int _mapw;
    public static int _maph;
    private static int _nextCol;
    private static int _nextRow;
    private static int _nextAction;
    public static boolean _isNewGame;
    private Avatar _effectAni;
    private boolean _isPlayAni;
    private int _flightFram;
    private int _effectAniX;
    private int _effectAniY;
    private int _effectAniAction;
    private String _contextString;
    private boolean _rollStart;
    private boolean _rollEnd;
    private boolean _isScriptEnd;

    public static Scene getInstance() {
        if (_instance == null) {
            _instance = new Scene();
        }
        return _instance;
    }

    public static final void loadGlobalAniN97() {
        _resource = new ResourceManager(103, 103);
    }

    public static final void loadGlobalAni() {
        _resource.loadAvatar(0, 0);
        _resource.loadAvatar(1, 0);
        _resource.loadAvatar(2, 0);
        _resource.loadAvatar(60, 0);
        _resource.loadAvatar(62, 0);
        _resource.loadAvatar(69, 0);
        _resource.loadAvatar(70, 0);
        _resource.loadAvatar(71, 0);
        _resource.loadAvatar(72, 0);
        _resource.loadAvatar(75, 0);
        _resource.loadAvatar(76, 0);
        _resource.loadAvatar(77, 0);
        _resource.loadAvatar(78, 0);
        _resource.loadAvatar(79, 0);
        _resource.loadAvatar(80, 0);
        _resource.loadAvatar(81, 0);
        _resource.loadAvatar(88, 0);
        _resource.loadAvatar(93, 0);
        _resource.loadAvatar(100, 0);
        _resource.loadSpt(83, 0);
        _resource.loadSpt(84, 0);
    }

    private void miaoShaFocus() {
        if (_bombState == 2) {
            if (_actorExistFlag[0][this._nextEnemy] != -1) {
                Scene.setFocusActor(_mainActor[this._nextEnemy]);
                _bombState = 0;
                this._once = 0;
                ++this._inState;
            } else {
                ++this._nextEnemy;
            }
        }
    }

    private void initMiaoSha() {
        this._once = 0;
        this._inState = 0;
        this._nextEnemy = 0;
        this.fire = null;
    }

    public final void paint(Graphics graphics) throws Exception {
        graphics.setFont(Function.C_GAME_FONT);
        switch (_state) {
            case 0: {
                this.paintMap(graphics);
                this.paintActor(graphics);
                this.drawSceneName(graphics);
                this.drawPlayMovie(graphics);
                if (!_isInCity) {
                    SceneUI.getInstance().paint(graphics);
                }
                this.paintEffect(graphics);
                if (this._messageBox != null) {
                    this._messageBox.draw(graphics);
                }
                this.paintFace(graphics);
                this.paintMoveScreen(graphics);
                this.drawShowString(graphics);
                if (!_isInCity) break;
                this.sceneKeySign(graphics);
                break;
            }
            case 1: {
                this.paintWin(graphics);
                break;
            }
            case 2: {
                this.paintMap(graphics);
                this.paintActor(graphics);
                this.paintBattleResult(graphics, 76, 1, 160);
                if (!_isInCity) {
                    SceneUI.getInstance().paint(graphics);
                }
                Function.drawYesNoKey(graphics, true, true);
                break;
            }
            case 4: {
                this.paintMap(graphics);
                this.paintActor(graphics);
                SceneUI.getInstance().paint(graphics);
                switch (this._inState) {
                    case 0: {
                        if (_actorExistFlag[0][this._nextEnemy] != -1) {
                            Scene.setFocusActor(_mainActor[this._nextEnemy]);
                            _bombState = 0;
                            ++this._inState;
                            break;
                        }
                        ++this._nextEnemy;
                        break;
                    }
                    case 1: {
                        this.miaoShaFocus();
                        break;
                    }
                    case 2: {
                        this.miaoShaFocus();
                        break;
                    }
                    case 3: {
                        this.miaoShaFocus();
                    }
                }
                if (Scene._focus._type <= 2 || !this.endChangeFocus()) break;
                if (this._once == 0) {
                    this.fire = (Bomb)Scene.fetchActorForBomb(73);
                    this._once = 1;
                }
                if (this.fire == null) break;
                Bomb._hurtValue = 10000;
                Bomb._bombId = 22;
                this.fire.initFire(Scene._mainActor[this._nextEnemy]._x, Scene._mainActor[this._nextEnemy]._y, 0);
                ++this._nextEnemy;
                this.fire = null;
                break;
            }
            case 6: {
                this.paintMap(graphics);
                this.paintActor(graphics);
                if (_isInCity) {
                    this.sceneKeySign(graphics);
                    break;
                }
                SceneUI.getInstance().paint(graphics);
            }
        }
    }

    public final void paintFace(Graphics graphics) throws Exception {
        if (this._openFace) {
            _resource.getAvatation(62).draw(graphics, this._openFaceX, this._openFaceY - 62, this._openFaceId, this._flightFram, 0);
            if (++this._flightFram > _resource.getAvatation(62).getActFrmNum(this._openFaceId) - 1) {
                this._flightFram = 0;
                this.closeSceneTeachOne();
            }
        }
    }

    public final void paintWin(Graphics graphics) throws Exception {
        Function.drawBackGroud(graphics, 2, 10, 233, 305);
        this.paintBattleResult(graphics, 76, 0, 70);
        Function.drawBorder(graphics, 12, 106, 216, 90);
        Function.drawBorder(graphics, 12, 206, 216, 90);
        graphics.setColor(0);
        if (_level != 14 && _level != 22 && _level != 30 && _level != 38) {
            graphics.drawString("C\u1eeda ti\u1ebfp theo: " + this._nextSceneName[_level], 120, 115, 17);
        } else {
            graphics.drawString("Ch\u00fac m\u1eebng v\u01b0\u1ee3t qua c\u1eeda \u1ea3i", 120, 115, 17);
        }
        int n = 0;
        n = 0;
        while (n < 7) {
            _resource.getSptSet(81).draw(graphics, 40 + 24 * n, 166, 27, 0, 0);
            ++n;
        }
        if (_level != 14 && _level != 22 && _level != 30 && _level != 38) {
            n = 0;
            while (n < 8) {
                int n2;
                if (n == 7) {
                    _resource.getSptSet(81).draw(graphics, 25 + 24 * n, 144, 29, 0, 0);
                }
                int n3 = n2 = (_level - 6) / 8 > 0 ? (_level - 6) / 8 : 0;
                if (GameInterface._mapFlag[1 + n2 * 8 + n]) {
                    _resource.getSptSet(81).draw(graphics, 25 + 24 * n, 160, 26, 0, 0);
                } else {
                    _resource.getSptSet(81).draw(graphics, 25 + 24 * n, 160, 25, 0, 0);
                }
                if (n != 0 && GameInterface._mapFlag[_level - 5]) {
                    _resource.getSptSet(81).draw(graphics, 25 + 24 * ((_level - 6) % 8), 160, 26, 0, 0);
                    _resource.getAvatation(81).draw(graphics, 33 + 24 * ((_level - 6) % 8), 167, 4, this._winCurLevelNum, 0);
                }
                ++n;
            }
            _resource.getSptSet(81).draw(graphics, 120, 210, 30, 0, 17);
        } else {
            n = 0;
            while (n < 8) {
                if (n == 7) {
                    _resource.getSptSet(81).draw(graphics, 25 + 24 * n, 144, 29, 0, 0);
                }
                _resource.getSptSet(81).draw(graphics, 25 + 24 * n, 160, 26, 0, 0);
                ++n;
            }
            graphics.setClip(0, 0, 240, 320);
            this._winCurIndex = 1;
            graphics.setColor(0);
            graphics.drawString("Nh\u1ea5n tr\u1edf v\u1ec1 th\u00e0nh tr\u1ea5n", 120, 220, 17);
        }
        _resource.getSptSet(81).draw(graphics, 120, 255, 31, 0, 17);
        _resource.getSptSet(80).draw(graphics, 160, 233 + this._winCurIndex * 45, 22, 0, 17);
        ++this._winCurLevelNum;
        if (this._winCurLevelNum > _resource.getAvatation(81).getActFrmNum(4) - 1) {
            this._winCurLevelNum = 0;
        }
    }

    public final void paintMap(Graphics graphics) throws Exception {
        int n = (_camx >> 10) - this._cameraOffsetX;
        int n2 = (_camy >> 10) - this._cameraOffsetY;
        this._bk.setMapPosition(n, n2);
        this._bk.drawDistant(graphics);
        this._bk.drawMedium(graphics);
        this._bk.drawFore(graphics);
    }

    private final void paintBattleResult(Graphics graphics, int n, int n2, int n3) {
        ++this._frame;
        if (this._frame >= _resource.getAvatation(n).getActFrmNum(n2)) {
            this._frame = _resource.getAvatation(n).getActFrmNum(n2) - 1;
        }
        _resource.getAvatation(n).draw(graphics, 120, n3, n2, this._frame, 0);
        if (_resultString != null && n2 == 1) {
            graphics.setColor(0xFF0000);
            Function.draw3DString(graphics, _resultString.substring(0, 8), 120, 213 - Function.C_WORD_H, 0x10 | 1, 0xFF0000, 0xFFFFFF);
            Function.draw3DString(graphics, _resultString.substring(8), 120, 213, 0x10 | 1, 0xFF0000, 0xFFFFFF);
        }
    }

    private final void updateBattleWin() {
        int n = KeyCode.getCurKey();
        switch (n) {
            case 4: {
                this._winCurIndex = 0;
                break;
            }
            case 8: {
                this._winCurIndex = 1;
            }
        }
        if (KeyCode.isPressFireKey()) {
            SceneUI.getInstance().setCloseToolGrid(false);
            if (this._winCurIndex == 0) {
                this.getGameLogic();
                GameMainLogic._interface.changeLevel(_level, -1, -1);
            } else {
                this.setFollow();
                this.getGameLogic();
                GameMainLogic._interface.changeLevel(3, 16, 12);
            }
            this._winCurIndex = 0;
            Function.stopSound();
        }
    }

    private final void updateBattleOver() {
        if (KeyCode.isPressConfirmSoftKey()) {
            this._frame = 0;
            GameMainLogic._interface.setInMenuState(false);
            this._gic.changeState((byte)0);
            GameMainLogic._interface.changeState((byte)10);
        }
        if (KeyCode.isPressCancelSoftKey()) {
            this._frame = 0;
            GameMainLogic._interface.setInMenuState(false);
            this._gic.changeState((byte)0);
            GameMainLogic._interface.changeState((byte)4);
        }
    }

    private final void paintActor(Graphics graphics) {
        this.sortDraw(_insts, _activeNum);
        int n = _camx >> 10;
        int n2 = _camy >> 10;
        int n3 = 0;
        while (n3 < _activeNum) {
            _insts[n3].draw(graphics, n, n2, this._cameraOffsetX, this._cameraOffsetY);
            ++n3;
        }
    }

    public void initSceneName() {
        this._enterNewSceneTime = -10;
        this._isChangetoNewScene = true;
        this.sceneColor = 9047521;
        this.sceneName = this._nextSceneName[_level];
    }

    private final void drawSceneName(Graphics graphics) {
        if (this._isChangetoNewScene) {
            if (this._enterNewSceneTime++ >= 0 && this._enterNewSceneTime < 20) {
                if (this.sceneName != null) {
                    int n;
                    int n2 = this.sceneName.length();
                    int n3 = graphics.getFont().charWidth('\u4f60');
                    int n4 = graphics.getFont().getHeight();
                    graphics.setColor(this.sceneColor);
                    if (this._enterNewSceneTime < 5 || this._enterNewSceneTime >= 19 && this._enterNewSceneTime < 23) {
                        n = this._enterNewSceneTime >= 19 ? 23 - this._enterNewSceneTime : this._enterNewSceneTime;
                        graphics.drawLine(120 - n3 * n2 / 2, 110, 120 - n3 * n2 / 2 + n3 * n * n2 / 4, 110);
                        graphics.setColor(0xFFFFFF);
                        graphics.drawRect(120 - n3 * n2 / 2 - 1, 109, n3 * n * n2 / 4 + 1, 2);
                    } else if (this._enterNewSceneTime >= 5 && this._enterNewSceneTime < 19) {
                        graphics.drawLine(120 - n3 * n2 / 2, 110, 120 + n3 * n2 / 2, 110);
                        graphics.setColor(0xFFFFFF);
                        graphics.drawRect(120 - n3 * n2 / 2 - 1, 109, n3 * n2 + 1, 2);
                    }
                    graphics.setClip(120 - n3 * n2 / 2, 110 - n4, n3 * n2, n4);
                    if (this._enterNewSceneTime >= 5 && this._enterNewSceneTime < 9 || this._enterNewSceneTime >= 15 && this._enterNewSceneTime < 19) {
                        n = this._enterNewSceneTime >= 15 ? 19 - this._enterNewSceneTime : this._enterNewSceneTime - 4;
                        Function.draw3DString(graphics, this.sceneName, 120, 110 - n * n4 / 4, 1 | 0x10, 0xFFFFFF, this.sceneColor);
                    } else if (this._enterNewSceneTime >= 9 && this._enterNewSceneTime < 15) {
                        Function.draw3DString(graphics, this.sceneName, 120, 110 - n4, 1 | 0x10, 0xFFFFFF, this.sceneColor);
                    }
                }
            } else if (this._enterNewSceneTime >= 20) {
                this._isChangetoNewScene = false;
            }
            graphics.setClip(0, 0, 240, 320);
        }
    }

    private final void sortDraw(Actor[] actorArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n2 = 0;
        while (n2 < n - 1) {
            n4 = n2;
            n3 = n2 + 1;
            while (n3 < n) {
                if (this.compareDraw(actorArray[n3], actorArray[n4])) {
                    n4 = n3;
                }
                ++n3;
            }
            if (n2 != n4) {
                Actor actor = actorArray[n2];
                actorArray[n2] = actorArray[n4];
                actorArray[n4] = actor;
            }
            ++n2;
        }
    }

    private final void sortUpdata(Actor[] actorArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n2 = 0;
        while (n2 < n - 1) {
            n4 = n2;
            n3 = n2 + 1;
            while (n3 < n) {
                if (this.compareUpdata(actorArray[n3], actorArray[n4])) {
                    n4 = n3;
                }
                ++n3;
            }
            if (n2 != n4) {
                Actor actor = actorArray[n2];
                actorArray[n2] = actorArray[n4];
                actorArray[n4] = actor;
            }
            ++n2;
        }
    }

    private boolean compareDraw(Actor actor, Actor actor2) {
        if (actor == null || actor2 == null) {
            return false;
        }
        if (actor.getDrawPriority() < actor2.getDrawPriority()) {
            return true;
        }
        if (actor.getDrawPriority() > actor2.getDrawPriority()) {
            return false;
        }
        return actor._y < actor2._y;
    }

    private boolean compareUpdata(Actor actor, Actor actor2) {
        if (actor == null || actor2 == null) {
            return false;
        }
        if (actor.getUpdatePriority() < actor2.getUpdatePriority()) {
            return false;
        }
        if (actor.getUpdatePriority() > actor2.getUpdatePriority()) {
            return true;
        }
        return actor._y < actor2._y;
    }

    public final void update() throws IOException {
        switch (_state) {
            case 0: {
                this.updateCameraOffset();
                this.keyMoveScreen();
                if (this._messageBox != null) {
                    this._messageBox.update();
                }
                this.updateScript();
                this.updateActors();
                this.updateSector();
                this.updateCaptors();
                if (!_isInCity) {
                    SceneUI.getInstance().update();
                    _focus.moveScreen();
                }
                if (GameMainLogic._gameScenario == 56 && this.isFinishCurTask(3)) {
                    GameMainLogic._gameScenario = 60;
                }
                if (!this._openMoveSceen) {
                    this.updateCamera();
                }
                this.sceneKeyHandle();
                break;
            }
            case 1: {
                this.updateBattleWin();
                break;
            }
            case 2: {
                this.updateBattleOver();
                break;
            }
            case 4: {
                this.updateCameraOffset();
                this.updateActors();
                this.updateSector();
                this.updateCamera();
            }
        }
    }

    public void updateScript() {
        if (this._isChangetoNewScene) {
            return;
        }
        if (this._parser != null) {
            this._parser.exec();
        }
    }

    public boolean isScriptEnd() {
        if (this._parser != null) {
            return this._parser.isScriptEnd();
        }
        return true;
    }

    private final void updateCaptors() throws IOException {
        if (_sectorCaptorId[this._curSector] != null) {
            int n = 0;
            while (n < _sectorCaptorId[this._curSector].length) {
                this.checkCaptor(_sectorCaptorId[this._curSector][n]);
                ++n;
            }
        }
    }

    public boolean isMainTeamOver() {
        int n = 0;
        while (n < _tankOneTeamNum) {
            if (!_mainActor[n].isDeathState()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isMainTeamWin() {
        int n = 0;
        while (n < _tankTwoTeamNum) {
            if (_actorExistFlag[0][n + _tankOneTeamNum] > 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void changeToWinOrFail() {
        if (this.isMainTeamWin()) {
            this._frame = 0;
            if ((_level = (byte)(_level + 1)) - 6 < 32 && _level - 5 != 25 && _level - 5 != 9 && _level - 5 != 17) {
                this.changeMapShow(_level - 5);
            }
            Scene.setFocusActor(_mainActor[0]);
            if (_level == 10 && GameMainLogic._gameScenario == 35) {
                GameMainLogic._interface.changeLevel(50, -1, -1);
                this.changeState((byte)9);
            } else if (_level == 17 && GameMainLogic._gameScenario == 80) {
                GameMainLogic._interface.changeLevel(51, -1, -1);
                this.changeState((byte)9);
            } else if (_level == 30 && GameMainLogic._gameScenario == 110) {
                GameMainLogic._interface.changeLevel(52, -1, -1);
                this.changeState((byte)9);
            } else if (_level == 33 && GameMainLogic._gameScenario == 150) {
                GameMainLogic._interface.changeLevel(5, 2, 12);
                this.changeState((byte)9);
            } else if (_level == 38 && GameMainLogic._gameScenario == 175) {
                GameMainLogic._interface.changeLevel(38, -1, -1);
                this.changeState((byte)9);
            } else if (_level == 39 && GameMainLogic._gameScenario == 180) {
                GameMainLogic._interface.changeLevel(53, -1, -1);
                this.changeState((byte)9);
            } else if (_level == 14 && GameMainLogic._gameScenario == 55) {
                GameMainLogic._gameScenario = 56;
                RoleTeamData.getInstance().consumeTool(35, 1);
                Function.changeSoundState(6, -1);
                this.changeState((byte)1);
            } else if (_level == 14 || _level == 22 || _level == 30 || _level == 38) {
                Function.changeSoundState(6, -1);
                this.changeState((byte)1);
            } else {
                Function.changeSoundState(6, -1);
                this.changeState((byte)1);
            }
            return;
        }
        if (this.isMainTeamOver()) {
            this._frame = 0;
            Scene.setFocusActor(_mainActor[0]);
            _resultString = "Tr\u00f2 ch\u01a1i th\u1ea5t b\u1ea1i, x\u00e1c nh\u1eadn \u0111\u1ecdc l\u01b0u tr\u1eef.";
            this.changeState((byte)2);
            return;
        }
    }

    public final void updateBattleResult() {
        Actor actor = null;
        int n = 0;
        while (n < _activeInsts.length) {
            if (_activeInsts[n] != null && Scene._activeInsts[n]._type == 73) {
                actor = _activeInsts[n];
                break;
            }
            ++n;
        }
        if (actor != null) {
            if (actor.isActionEnd()) {
                this.changeToWinOrFail();
            }
        } else {
            this.changeToWinOrFail();
        }
    }

    public final void updateSector() {
        byte by;
        int n = _camx >> 10;
        int n2 = _camy >> 10;
        this._bk.setPositionInMap(n, n2);
        int n3 = n2 / this._sectorHeight * (this._bk.getWidth() / this._sectorWidth) + n / this._sectorWidth;
        if (n3 == this._curSector) {
            return;
        }
        int n4 = 0;
        int n5 = 0;
        byte by2 = 0;
        while (_sectorActorId[this._curSector] != null && _sectorActorId[n3] != null && n4 < _sectorActorId[this._curSector].length && n5 < _sectorActorId[n3].length) {
            by = _sectorActorId[this._curSector][n4];
            byte by3 = _sectorActorId[n3][n5];
            if (by < by3) {
                if (_activeInsts[by] != null) {
                    _activeInsts[by].disActive();
                }
                ++n4;
                continue;
            }
            if (by > by3) {
                Scene._newIds[by2++] = _sectorActorId[n3][n5++];
                continue;
            }
            ++n4;
            ++n5;
        }
        while (_sectorActorId[this._curSector] != null && n4 < _sectorActorId[this._curSector].length) {
            if (_activeInsts[_sectorActorId[this._curSector][n4]] != null) {
                _activeInsts[_sectorActorId[this._curSector][n4]].disActive();
            }
            ++n4;
        }
        while (_sectorActorId[n3] != null && n5 < _sectorActorId[n3].length) {
            if (_sectorActorId[n3][n5] != 0) {
                Scene._newIds[by2++] = _sectorActorId[n3][n5];
            }
            ++n5;
        }
        by = 0;
        while (by < by2) {
            this.fetchActorFromPool(-1, _newIds[by]);
            ++by;
        }
        this._curSector = n3;
    }

    public boolean isHitState(int n) {
        return _bombState == n;
    }

    private final void updateActors() {
        if (this._openMoveSceen) {
            return;
        }
        _activeNum = 0;
        int n = 0;
        n = 0;
        while (n < _activeInsts.length) {
            Scene._insts[n] = null;
            ++n;
        }
        n = 0;
        while (n < _activeInsts.length) {
            if (_activeInsts[n] != null) {
                Scene._insts[Scene._activeNum++] = _activeInsts[n];
            }
            ++n;
        }
        this.sortUpdata(_insts, _activeNum);
        n = 0;
        while (n < _activeNum) {
            if (Scene._insts[n]._active) {
                _insts[n].step();
                _insts[n].ai();
            }
            ++n;
        }
        switch (_bombState) {
            case 0: {
                if (this.getceneTeach()) {
                    return;
                }
                if (SceneUI.getInstance().isCountDownZero()) {
                    SceneUI.getInstance().closeCountDown();
                    if (((MainActor)Scene._focus)._type <= 2) {
                        this.endBombing();
                    }
                }
                if (!this.endChangeFocus() || !this.isScriptEnd() || !(_focus instanceof MainActor) || !((MainActor)_focus).useTooleFinish()) break;
                this.endBombing();
                break;
            }
            case 1: {
                if (this.isLockCamera()) {
                    this.unlockCamera();
                }
                if (!this.endChangeFocus()) break;
                this.newTurn();
                break;
            }
            case 2: {
                if ((this.getceneTeach() || !this.isScriptEnd()) && this.getPressKey() == 7) {
                    this.closeSceneTeachOne();
                    this.closeSceneTeachTwo();
                    return;
                }
                if (_isInCity) break;
                if (!Bomb.ISDEATH) {
                    this.updateBattleResult();
                }
                if (_state != 0) break;
                this.sceneBombing();
                break;
            }
            case 3: {
                if (this.isLockCamera()) {
                    this.unlockCamera();
                }
                if (!this.endChangeFocus() || !(_focus instanceof MainActor) || !((MainActor)_focus).useTooleFinish()) break;
                if (!_isInCity) {
                    this.endBombing();
                    break;
                }
                this.setMainFocus();
                int n2 = 1;
                while (n2 < 3) {
                    if (RoleTeamData.getInstance().getExistFlag(n2)) {
                        int n3 = 0;
                        while (n3 < _activeInsts.length) {
                            if (_activeInsts[n3] != null && Scene._activeInsts[n3]._type == n2) {
                                MainActor mainActor = (MainActor)_activeInsts[n3];
                                mainActor.initInfo();
                                if (mainActor._type == 1) {
                                    mainActor.changeToFollower(_focus, 30720);
                                } else if (mainActor._type == 2) {
                                    mainActor.changeToFollower(_focus, 81920);
                                }
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
                _bombState = 0;
                break;
            }
            case 4: {
                if (this.isLockCamera()) {
                    this.unlockCamera();
                }
                if (!this.endChangeFocus() || !(_focus instanceof MainActor) || !((MainActor)_focus).useTooleFinish()) break;
                isAllEnd = false;
            }
        }
    }

    public static void changeFocus(Actor actor, byte by) {
        _focus = actor;
        _bombState = by;
    }

    private void sceneBombing() {
        Bomb.initGlobalData();
        int n = this.selectNextTank();
        if (n >= 0) {
            if (_mainActor[n].takeFocus()) {
                Scene.changeFocus(_mainActor[n], (byte)1);
                ((MainActor)_focus).consumeFuel(40);
            } else {
                this.sceneBombing();
            }
        }
    }

    public void isFinishOneTeam() {
        int n = 0;
        int n2 = 0;
        n2 = 0;
        while (n2 < _tankOneTeamNum) {
            if (_actorExistFlag[2][n2] != 1 && !_mainActor[n2].isDeathState()) break;
            ++n2;
        }
        if (n2 == _tankOneTeamNum) {
            n = 0;
            while (n < _tankOneTeamNum) {
                Scene._actorExistFlag[2][n] = 0;
                ++n;
            }
        }
        n2 = 0;
        while (n2 < _tankTwoTeamNum) {
            if (_actorExistFlag[2][_tankOneTeamNum + n2] != 1 && _actorExistFlag[0][_tankOneTeamNum + n2] >= 0) break;
            ++n2;
        }
        if (n2 == _tankTwoTeamNum) {
            n = 0;
            while (n < _tankTwoTeamNum) {
                Scene._actorExistFlag[2][Scene._tankOneTeamNum + n] = 0;
                ++n;
            }
        }
    }

    public int selectNextTank() {
        int n = 0;
        boolean bl = false;
        int n2 = -1;
        this.isFinishOneTeam();
        n = 0;
        while (n < _tankNum) {
            if (_actorExistFlag[3][n] == this.getMaxValue(_actorExistFlag[3]) && _actorExistFlag[2][n] == 0 && _actorExistFlag[0][n] != -1) {
                n2 = n;
                this._lastTeam = _actorExistFlag[1][n];
                break;
            }
            if (_actorExistFlag[3][n] == this.getMaxValue(_actorExistFlag[3]) && _actorExistFlag[2][n] == 0 && _mainActor[n].isDeathState()) {
                n2 = n;
                this._lastTeam = _actorExistFlag[1][n];
                break;
            }
            ++n;
        }
        if (n2 >= 0) {
            Scene._actorExistFlag[2][n2] = 1;
        }
        return n2;
    }

    public int getMaxValue(int[] nArray) {
        int n = 0;
        int n2 = 0;
        n2 = 0;
        while (n2 < _tankNum) {
            if (_actorExistFlag[0][n2] >= 0 && _actorExistFlag[2][n2] <= 0 && _actorExistFlag[1][n2] != this._lastTeam && !_mainActor[n2].isDeathState()) {
                ++n;
            }
            ++n2;
        }
        if (n <= 0) {
            return 0;
        }
        int[] nArray2 = new int[n];
        n = 0;
        n2 = 0;
        while (n2 < _tankNum) {
            if (_actorExistFlag[0][n2] >= 0 && _actorExistFlag[2][n2] <= 0 && _actorExistFlag[1][n2] != this._lastTeam && !_mainActor[n2].isDeathState()) {
                nArray2[n] = nArray[n2];
                ++n;
            }
            ++n2;
        }
        int n3 = 0;
        n = 0;
        while (n < nArray2.length) {
            n2 = 0;
            while (n2 < nArray2.length - 1) {
                if (nArray2[n2] < nArray2[n2 + 1]) {
                    n3 = nArray2[n2];
                    nArray2[n2] = nArray2[n2 + 1];
                    nArray2[n2 + 1] = n3;
                }
                ++n2;
            }
            ++n;
        }
        return nArray2[0];
    }

    public void doScript(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/res/");
        stringBuffer.append(n);
        stringBuffer.append(".s2n");
        if (n2 > 0) {
            int n3 = n;
            if (this.findScriptStatusInDoc(n3)) {
                return;
            }
            this.saveScriptStatusToDoc(n3);
        }
        this._parser = null;
        this._parser = new S2nParser(stringBuffer.toString(), -1, this, null);
        this._parser.buildToTree();
    }

    protected void saveScriptStatusToDoc(int n) {
        int n2 = 0;
        while (n2 < _scriptSave.length) {
            if (_scriptSave[n2] == 0) {
                Scene._scriptSave[n2] = (byte)n;
                Scene._scriptSave[n2 + 1] = (byte)(n >> 8);
                break;
            }
            n2 += 2;
        }
    }

    protected boolean findScriptStatusInDoc(int n) {
        int n2 = 0;
        while (n2 < _scriptSave.length) {
            if (R.readInt(_scriptSave, n2, 2) == n) {
                return true;
            }
            n2 += 2;
        }
        return false;
    }

    public void calcTarget() {
        int n = 240;
        int n2 = 320;
        int n3 = this._bk.getWidth();
        int n4 = this._bk.getHeight();
        int n5 = _isInCity ? 0 : 50;
        _camDestx = _focus.getXDirLocation(n << 10);
        _camDesty = _focus.getYDirLocation(n2 << 10);
        int n6 = _camDestx >> 10;
        int n7 = _camDesty >> 10;
        n6 = Math.min(n6, n3 - 240 - 1);
        n6 = Math.max(n6, 0);
        n7 = Math.min(n7, n4 - (320 - n5) - 1);
        n7 = Math.max(n7, 0);
        _camDestx = n6 << 10;
        _camDesty = n7 << 10;
    }

    public boolean endChangeFocus() {
        this.calcTarget();
        int n = Math.abs(_camDestx - _camx);
        int n2 = Math.abs(_camDesty - _camy);
        if (n > n2) {
            if (n < 20480) {
                _camx = _camDestx;
                _camy = _camDesty;
                _camvy = 0;
                _camvx = 0;
                return true;
            }
            _camvx = _camDestx > _camx ? 20480 : -20480;
            _camvy = 20 * n2 / n;
            _camvy <<= 10;
            if (_camDesty < _camy) {
                _camvy = -_camvy;
            }
        } else {
            if (n2 < 20480) {
                _camx = _camDestx;
                _camy = _camDesty;
                _camvy = 0;
                _camvx = 0;
                return true;
            }
            _camvy = _camDesty > _camy ? 20480 : -20480;
            _camvx = 20 * n / n2;
            _camvx <<= 10;
            if (_camDestx < _camx) {
                _camvx = -_camvx;
            }
        }
        return _camvx > 0 && _camx + _camvx > _mapw || _camvx < 0 && _camx + _camvx < 0;
    }

    public void newTurn() {
        SceneUI.getInstance().changeWind();
        _bombState = 0;
        if ((this.getceneTeach() || !this.isScriptEnd()) && this.getPressKey() == 5 && Scene.isMainActor(_focus)) {
            this.closeSceneTeachOne();
            this.closeSceneTeachTwo();
            _focus.changeToWait();
        }
        if (Scene._focus._type < 3) {
            SceneUI.getInstance().openCountDown();
        }
    }

    public static Actor fetchActorForBomb(int n) {
        int n2 = 0;
        while (n2 < _actorPool[n].length) {
            Actor actor = _actorPool[n][n2];
            if (!actor._active) {
                int n3;
                if (n >= 61) {
                    n3 = 30;
                    while (n3 < _activeInsts.length) {
                        if (_activeInsts[n3] == null) {
                            Scene._activeInsts[n3] = actor;
                            _activeInsts[n3].activate(_instance, n3);
                            return actor;
                        }
                        ++n3;
                    }
                } else {
                    n3 = 0;
                    while (n3 < _activeInsts.length) {
                        if (_activeInsts[n3] == null) {
                            Scene._activeInsts[n3] = actor;
                            _activeInsts[n3].activate(_instance, n3);
                            return actor;
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    public int calcSlope(int n, int n2, int n3) {
        int n4;
        n >>= 10;
        n2 >>= 10;
        int n5 = 0;
        int n6 = 12;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < 13) {
            n4 = 0;
            while (n4 < 13) {
                if (this.isSolidPoint(null, n - 6 + n9, n2 - 6 + n4)) {
                    if (n4 < n6) {
                        n6 = n4;
                        n5 = n9;
                    }
                    if (n4 <= n8) break;
                    n8 = n4;
                    n7 = n9;
                    break;
                }
                ++n4;
            }
            ++n9;
        }
        n4 = Math.abs(n5 - n7);
        if (n4 == 0) {
            return 0;
        }
        int n10 = Math.abs(n8 - n6);
        if (n10 <= 3) {
            return 0;
        }
        int n11 = (n10 << 10) / n4;
        int n12 = 0;
        int n13 = 80;
        while (n12 < n13) {
            int n14 = (n12 + n13) / 2;
            if (n11 == Function.tan(n14)) break;
            if (n11 > Function.tan(n14)) {
                n12 = n14 + 1;
                continue;
            }
            n13 = n14 - 1;
        }
        n9 = n5 < n7 ? (n3 != 0 ? 1 : -1) : (n3 != 0 ? -1 : 1);
        return n12 * n9;
    }

    public boolean findSolidPoint(int n, int n2, int n3, int[] nArray) {
        int n4 = n2;
        while (n4 < n3) {
            if (this.isSolidPoint(null, n, n4)) {
                nArray[0] = n;
                nArray[1] = n4;
                return true;
            }
            n4 += 2;
        }
        return false;
    }

    public boolean isSolidPoint(byte[] byArray, int n, int n2) {
        if (byArray == null && (byArray = this._bk.getPhys(n, n2)) == null) {
            return false;
        }
        int n3 = this._bk.getTileWidth();
        int n4 = this._bk.getTileHeigth();
        int n5 = n % n3;
        int n6 = n2 % n4;
        int n7 = 0;
        int n8 = 0;
        n7 = n6 * n3 / 8;
        n8 = n5 / 8;
        int n9 = n5 % 8;
        byte by = byArray[n7 + n8];
        int n10 = 0;
        while (n10 < n9) {
            by = (byte)(by << 1);
            ++n10;
        }
        return (by & 0x80) != 0;
    }

    public void endBombing() {
        _bombState = 2;
    }

    public static boolean isMainActor(Actor actor) {
        switch (actor._type) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean isSolidArea(byte[] byArray, int n, int n2, int n3, int n4) {
        if (byArray == null) {
            byArray = this._bk.getPhys(n, n2);
        }
        if (byArray != null) {
            int n5 = this._bk.getTileWidth();
            int n6 = this._bk.getTileHeigth();
            int n7 = n % n5;
            int n8 = n2 % n6;
            int n9 = n8 * n5 / 8;
            int n10 = n7 / 8;
            int n11 = n7 % 8;
            int n12 = 0;
            int n13 = 0;
            while (n13 < n3 && n8 + n13 < n6) {
                byte by = byArray[n9 + n5 / 8 * n13 + n10];
                if (((by = (byte)(by >> n11)) & 0x80) != 0) {
                    ++n12;
                }
                ++n13;
            }
            if (n12 >= n4) {
                return true;
            }
        }
        return false;
    }

    private void sceneKeyHandle() {
        if (!this.isScriptEnd() || SceneUI.getInstance().isOpen() || Scene._focus._type > 2 || this._openMoveSceen) {
            return;
        }
        if (Scene._focus._closeAI) {
            return;
        }
        if (KeyCode.isPressSystemConfirmSoftKey()) {
            this._gic.changeState((byte)0);
            GameMainLogic._interface.changeState((byte)18);
            GameMainLogic._interface.setInMenuState(true);
        }
        if (KeyCode.isPressSystemCancelSoftKey() && this.isIntoFuncMenu()) {
            this._gic.changeState((byte)0);
            GameMainLogic._interface.changeState((byte)19);
            this.changeState((byte)6);
            GameMainLogic._interface.getGameUI().init(0);
        }
    }

    private boolean isIntoFuncMenu() {
        if (Scene._focus._type > 2) {
            return false;
        }
        MainActor mainActor = (MainActor)_focus;
        return this.isCameraStop() && mainActor.isCommonState() && _bombState != 3;
    }

    private void sceneKeySign(Graphics graphics) {
        if (!this.isScriptEnd() || SceneUI.getInstance().isOpen()) {
            return;
        }
        Function.drawLeftRightKey(graphics, true, true);
    }

    private static void initCityFlag(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                _isInCity = true;
                break;
            }
            default: {
                _isInCity = false;
            }
        }
    }

    public static boolean produceScene(GameMainLogic gameMainLogic, byte by) {
        try {
            switch (produceProcess) {
                case 0: {
                    _instance = Scene.produceInstance(gameMainLogic, by);
                    Scene.initCityFlag(by);
                    produceProcess = 1;
                    break;
                }
                case 1: {
                    _instance.loadSceneMap(_is);
                    produceProcess = (byte)2;
                    break;
                }
                case 2: {
                    _instance.loadSceneData(_is);
                    produceProcess = (byte)3;
                    break;
                }
                case 3: {
                    _instance.loadSceneCaptor(_is);
                    produceProcess = (byte)4;
                    break;
                }
                case 4: {
                    _instance.loadSceneActor(_is);
                    produceProcess = (byte)5;
                    break;
                }
                case 5: {
                    _instance.loadSectorCaptorId(_is);
                    produceProcess = (byte)6;
                    break;
                }
                case 6: {
                    _instance.loadSectorGlobalData(_is);
                    produceProcess = (byte)7;
                    break;
                }
                case 7: {
                    _instance.produceActorPool();
                    produceProcess = (byte)8;
                    break;
                }
                case 8: {
                    produceProcess = 0;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private static Scene produceInstance(GameMainLogic gameMainLogic, byte by) {
        Scene scene = Scene.getInstance();
        scene._gic = gameMainLogic;
        _level = by;
        try {
            _is = R.openDataInputStream("/res/s" + by + ".xsc", -1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return scene;
    }

    private void loadSceneMap(DataInputStream dataInputStream) throws Exception {
        this._sectorWidth = dataInputStream.readShort();
        this._sectorHeight = dataInputStream.readShort();
        byte by = R.readByte(dataInputStream);
        if (by == 2) {
            byte by2 = dataInputStream.readByte();
            byte by3 = dataInputStream.readByte();
        }
        byte by4 = dataInputStream.readByte();
        byte by5 = dataInputStream.readByte();
        this._bk = TiledBackground.load(this._gic, by5);
    }

    private void loadSceneData(DataInputStream dataInputStream) throws Exception {
        _types = dataInputStream.readByte();
        int n = 0;
        while (n < _types) {
            Scene._typesLoad[n][0] = dataInputStream.readByte();
            Scene._typesLoad[n][1] = dataInputStream.readByte();
            if (_typesLoad[n][1] < 0) {
                byte[] byArray = _typesLoad[n];
                byArray[1] = (byte)(byArray[1] + 256);
            }
            ++n;
        }
    }

    private void loadSceneCaptor(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readByte();
        _captorInitData = new byte[n][];
        _captorInstTriged = new boolean[n];
        _captorInstCheckin = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInputStream.readByte();
            Scene._captorInitData[n2] = new byte[n3 += 22];
            dataInputStream.read(_captorInitData[n2]);
            ++n2;
        }
    }

    private void loadSceneActor(DataInputStream dataInputStream) throws Exception {
        _staticActorNum = dataInputStream.readByte();
        _activeInsts = new Actor[_staticActorNum + 50];
        _insts = new Actor[_staticActorNum + 50];
        _actorInitData = new byte[_staticActorNum][];
        _actorInstInited = new boolean[_staticActorNum];
        int n = 0;
        while (n < _staticActorNum) {
            int n2 = dataInputStream.readByte();
            Scene._actorInitData[n] = new byte[n2 += 7];
            dataInputStream.read(_actorInitData[n]);
            ++n;
        }
    }

    private void loadSectorCaptorId(DataInputStream dataInputStream) throws Exception {
        this._curSector = 0;
        this._sectorNum = this._bk.getHeight() / this._sectorHeight * (this._bk.getWidth() / this._sectorWidth);
        _sectorCaptorId = new byte[this._sectorNum][];
        int n = 0;
        while (n < this._sectorNum) {
            byte by = dataInputStream.readByte();
            if (by > 0) {
                Scene._sectorCaptorId[n] = new byte[by];
                dataInputStream.read(_sectorCaptorId[n]);
            }
            ++n;
        }
    }

    private void loadSectorGlobalData(DataInputStream dataInputStream) throws Exception {
        _globalActorNum = dataInputStream.readByte();
        _globalActorId = new byte[_globalActorNum];
        dataInputStream.read(_globalActorId);
        _sectorActorId = new byte[this._sectorNum][];
        int n = 0;
        while (n < this._sectorNum) {
            int n2 = dataInputStream.read();
            if (n2 > 0) {
                Scene._sectorActorId[n] = new byte[n2];
                dataInputStream.read(_sectorActorId[n]);
            }
            ++n;
        }
        dataInputStream.close();
    }

    public void produceActorPool() {
        int[][] nArrayArray = new int[][]{{61, 20}, {70, 10}, {73, 8}, {97, 6}, {72, 1}, {75, 6}, {77, 2}, {78, 1}, {79, 5}};
        int n = 0;
        while (n < nArrayArray.length) {
            _resource.loadAvatar(nArrayArray[n][0], 0);
            Scene.createActorPool(nArrayArray[n][0], nArrayArray[n][1]);
            ++n;
        }
        int n2 = 0;
        while (n2 < _types) {
            _resource.loadAvatar(_typesLoad[n2][0], _typesLoad[n2][1]);
            Scene.createActorPool(_typesLoad[n2][0], _typesLoad[n2][1]);
            ++n2;
        }
    }

    public static boolean loadGlobal(GameMainLogic gameMainLogic, int n) {
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                TiledBackground.loadBombMask();
                return true;
            }
        }
        return false;
    }

    public static void createActorPool(int n, int n2) {
        if (n < 0) {
            n += 256;
        }
        if (_actorPool[n] != null) {
            return;
        }
        Scene._actorPool[n] = new Actor[n2];
        int n3 = 0;
        while (n3 < n2) {
            Scene._actorPool[n][n3] = Actor.createActor(n, _resource.getAvatation(n));
            ++n3;
        }
    }

    public void initTeamInfo() {
        int n = 0;
        _tankNum = 0;
        _tankOneTeamNum = 0;
        _tankTwoTeamNum = 0;
        n = 0;
        while (n < _actorExistFlag[0].length) {
            Scene._actorExistFlag[0][n] = 0;
            Scene._actorExistFlag[2][n] = 0;
            ++n;
        }
        n = 0;
        while (n < _activeInsts.length) {
            if (_activeInsts[n] instanceof MainActor) {
                if (Scene._activeInsts[n]._type < 3) {
                    ++_tankOneTeamNum;
                } else {
                    ++_tankTwoTeamNum;
                }
                Scene._mainActor[Scene._tankNum] = (MainActor)_activeInsts[n];
                ++_tankNum;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < _tankNum) {
            n = 0;
            while (n < _tankNum - 1) {
                if (Scene._mainActor[n]._type > Scene._mainActor[n + 1]._type) {
                    MainActor mainActor = _mainActor[n];
                    Scene._mainActor[n] = _mainActor[n + 1];
                    Scene._mainActor[n + 1] = mainActor;
                }
                ++n;
            }
            ++n2;
        }
        if (!_isInCity) {
            int n3 = 0;
            while (n3 < _tankOneTeamNum) {
                _mainActor[n3].changeAction(0 | Scene._mainActor[n3]._flipFlag);
                ++n3;
            }
        }
        n = 0;
        while (n < _tankNum) {
            Scene._actorExistFlag[0][n] = 1;
            Scene._actorExistFlag[1][n] = Scene._mainActor[n]._type < 3 ? 0 : 1;
            _mainActor[n].initTeamIndex(n);
            Scene._actorExistFlag[3][n] = Scene._mainActor[n]._mainActorInfo[25];
            ++n;
        }
        Scene._actorExistFlag[2][0] = 1;
        this._lastTeam = 0;
    }

    public MainActor getMainActor(int n) {
        int n2 = 0;
        MainActor mainActor = null;
        n2 = 0;
        while (n2 < _activeInsts.length) {
            if (_activeInsts[n2] instanceof MainActor && Scene._activeInsts[n2]._type == n) {
                return (MainActor)_activeInsts[n2];
            }
            ++n2;
        }
        return mainActor;
    }

    public MainActor setHpForMainActor(int n) {
        int n2 = 0;
        MainActor mainActor = null;
        n2 = 0;
        while (n2 < _activeInsts.length) {
            if (_activeInsts[n2] instanceof MainActor && Scene._activeInsts[n2]._type == n) {
                mainActor = (MainActor)_activeInsts[n2];
                break;
            }
            ++n2;
        }
        Scene.setFocusActor(mainActor);
        _bombState = 3;
        return mainActor;
    }

    public void setExpForMainActor(int n) {
        Scene.setFocusActor(_mainActor[n]);
        _bombState = 4;
    }

    public void setFollow() {
        int n = 1;
        while (n < 3) {
            if (RoleTeamData.getInstance().getExistFlag(n)) {
                int n2 = 0;
                while (n2 < _activeInsts.length) {
                    if (_activeInsts[n2] != null && Scene._activeInsts[n2]._type == n) {
                        MainActor mainActor = (MainActor)_activeInsts[n2];
                        mainActor.initInfo();
                        if (mainActor._type == 1) {
                            mainActor.changeToFollower(_focus, 30720);
                            if (this.isScriptEnd()) {
                                mainActor.changeAction(_nextAction);
                            }
                        } else if (mainActor._type == 2) {
                            mainActor.changeToFollower(_focus, 81920);
                            if (this.isScriptEnd()) {
                                mainActor.changeAction(_nextAction);
                            }
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void setFollowChangeLeve() {
        int n = 1;
        while (n < 3) {
            if (RoleTeamData.getInstance().getExistFlag(n)) {
                int n2 = 0;
                while (n2 < _activeInsts.length) {
                    if (_activeInsts[n2] != null && Scene._activeInsts[n2]._type == n) {
                        MainActor mainActor = (MainActor)_activeInsts[n2];
                        mainActor.initInfo();
                        if (this.isChangePos()) {
                            mainActor._x = (_nextAction & 0xFF) == 1 ? Scene._focus._x + (mainActor._type * 30 << 10) : Scene._focus._x - (mainActor._type * 30 << 10);
                            mainActor._y = Scene._focus._y;
                        }
                        if (mainActor._type == 1) {
                            mainActor.changeToFollower(_focus, 30720);
                            if (this.isScriptEnd()) {
                                mainActor.changeAction(_nextAction);
                            }
                        } else if (mainActor._type == 2) {
                            mainActor.changeToFollower(_focus, 81920);
                            if (this.isScriptEnd()) {
                                mainActor.changeAction(_nextAction);
                            }
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void setMainFocus() {
        int n = 0;
        while (n < _activeInsts.length) {
            if (_activeInsts[n] != null && Scene._activeInsts[n]._type == 0) {
                Scene.setFocusActor(_activeInsts[n]);
                break;
            }
            ++n;
        }
    }

    public final void startup() {
        int n = 0;
        while (n < _globalActorId.length) {
            this.fetchActorFromPool(-1, _globalActorId[n]);
            ++n;
        }
        this.setMainFocus();
        if (!_isInCity) {
            n = 0;
            while (n < _activeInsts.length) {
                if (_activeInsts[n] != null) {
                    if (Scene._activeInsts[n]._type == 0 || Scene._activeInsts[n]._type == 1 || Scene._activeInsts[n]._type == 2) {
                        if (_activeInsts[n].needDisActive()) {
                            _activeInsts[n].disActive();
                        }
                    } else if (Scene._activeInsts[n]._type == 39 && _level == 9 && GameMainLogic._gameScenario > 40) {
                        _activeInsts[n].disActive();
                    }
                }
                ++n;
            }
        }
        if (this._isReadRMS) {
            this._isReadRMS = false;
            this.setFollow();
        }
        this.initCamera(_focus, this.getWidth(), this.getHeight());
        int n2 = _camx >> 10;
        int n3 = _camy >> 10;
        this._bk.init();
        this._bk.setPositionInMap(n2, n3);
        int n4 = n3 / this._sectorHeight * (this._bk.getWidth() / this._sectorWidth) + n2 / this._sectorWidth;
        n = 0;
        while (_sectorActorId[n4] != null && n < _sectorActorId[n4].length) {
            this.fetchActorFromPool(-1, _sectorActorId[n4][n]);
            ++n;
        }
        this.setMainActorPos();
        this.initTeamInfo();
        this.initMiaoSha();
        this.initSceneName();
        SceneUI.getInstance().openCountDown();
        _focus.changeToWait();
        if (_isNewGame) {
            ((MainActor)_focus).fullHp();
            _isNewGame = false;
        }
        _bombState = 0;
        _state = 0;
        Function.changeSoundState(Function.getSceneSoundId(_level), -1);
    }

    public final void initCamera(Actor actor, int n, int n2) {
        this._isLockedCamera = false;
        _camw = 245760;
        _camh = 327680;
        _camx = actor.getXDirLocation(_camw);
        _camy = actor.getYDirLocation(_camh);
        _camvy = 0;
        _camvx = 0;
        _mapw = n << 10;
        _maph = n2 << 10;
        this.validityCheckCamera(n, n2);
    }

    public void setMainActorPos() {
        if (this.isChangePos()) {
            int n = _nextCol * this._bk.tw + (this._bk.tw >> 1);
            int n2 = _nextRow * this._bk.th + this._bk.th;
            Scene._focus._x = n << 10;
            Scene._focus._y = n2 << 10;
            _camx = _focus.getXDirLocation(_camw);
            _camy = _focus.getYDirLocation(_camh);
            _focus.changeAction(_nextAction);
            Scene.setFocusActor(_focus);
            this.setFollowChangeLeve();
        }
    }

    private final void validityCheckCamera(int n, int n2) {
        int n3 = _camx >> 10;
        int n4 = _camy >> 10;
        int n5 = _isInCity ? 0 : 50;
        n3 = Math.min(n3, n - 240 - 1);
        n3 = Math.max(n3, 0);
        n4 = Math.min(n4, n2 - (320 - n5) - 1);
        n4 = Math.max(n4, 0);
        _camx = n3 << 10;
        _camy = n4 << 10;
    }

    public void updateCamera() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        if (this._isLockedCamera) {
            n4 = this._lockCameraXpos;
            n3 = this._lockCameraYpos;
        } else {
            n4 = _focus.getXDirLocation(_camw);
            n3 = _focus.getYDirLocation(_camh);
        }
        _preCamX = _camx;
        _preCamY = _camy;
        _camvy = 0;
        _camvx = 0;
        switch (Scene._focus._type) {
            case 0: {
                n2 = 30720;
                n = 30720;
                break;
            }
            default: {
                n2 = 30720;
                n = 30720;
            }
        }
        if (_camx < n4) {
            if (n4 - _camx > n2) {
                _camvx = n2;
            } else {
                _camx = n4;
            }
        } else if (_camx > n4) {
            if (_camx - n4 > n2) {
                _camvx = -n2;
            } else {
                _camx = n4;
            }
        }
        if (_camy < n3) {
            if (n3 - _camy > n) {
                _camvy = n;
            } else {
                _camy = n3;
            }
        } else if (_camy > n3) {
            if (_camy - n3 > n) {
                _camvy = -n;
            } else {
                _camy = n3;
            }
        }
        _camx += _camvx;
        _camy += _camvy;
        this.validityCheckCamera(n5, n6);
    }

    public void paintMoveScreen(Graphics graphics) {
        if (this._openMoveFlag) {
            this._effectAni.draw(graphics, this._openFlagX, this._openFlagY, this._openFlagAction, this._flightFram, 0);
            if (++this._flightFram > this._effectAni.getActFrmNum(this._openFlagAction) - 1) {
                this._flightFram = 0;
            }
        }
        if (this._openMoveSceenFlag) {
            int n = 0;
            while (n < MOVE_SCEEN_DATA.length) {
                if (KeyCode.getCurKey() == MOVE_SCEEN_DATA[n][2]) {
                    _resource.getSptSet(81).draw(graphics, MOVE_SCEEN_DATA[n][0], MOVE_SCEEN_DATA[n][1], MOVE_SCEEN_ACTION[n][0], 0, 0);
                } else {
                    _resource.getSptSet(81).draw(graphics, MOVE_SCEEN_DATA[n][0], MOVE_SCEEN_DATA[n][1], MOVE_SCEEN_ACTION[n][1], 0, 0);
                }
                ++n;
            }
        }
    }

    public void keyMoveScreen() {
        int n;
        int n2 = KeyCode.getCurKey();
        switch (n2) {
            case 4: {
                if (!this._openMoveSceen) break;
                this._camY -= 8;
                break;
            }
            case 8: {
                if (!this._openMoveSceen) break;
                this._camY += 8;
                break;
            }
            case 1: {
                if (!this._openMoveSceen) break;
                this._camX -= 8;
                break;
            }
            case 2: {
                if (!this._openMoveSceen) break;
                this._camX += 8;
                break;
            }
            case 256: {
                if (!this._openMoveSceen) {
                    this._bufferCamX = _camx;
                    this._bufferCamY = _camy;
                }
                this._camX = _camx >> 10;
                this._camY = _camy >> 10;
                if (this.getceneTeach()) {
                    if (this.getPressKey() == 0) {
                        boolean bl = this._openMoveSceen = !this._openMoveSceen;
                        if (this._openMoveSceen) {
                            this._openMoveFlag = false;
                            this._openMoveSceenFlag = true;
                        }
                        if (!this._openMoveSceen) {
                            this._openMoveFlag = false;
                            this._openMoveSceenFlag = false;
                            this.closeSceneTeachOne();
                            this.closeSceneTeachTwo();
                            Scene.setCamera(this._bufferCamX, this._bufferCamY);
                            KeyCode.resetCurKey();
                            return;
                        }
                    }
                } else if (this.isScriptEnd() && Scene._focus._type <= 2 && this.endChangeFocus()) {
                    boolean bl = this._openMoveSceen = !this._openMoveSceen;
                    this._openMoveSceenFlag = this._openMoveSceen;
                } else if (this._openMoveSceen) {
                    this._openMoveSceen = !this._openMoveSceen;
                    this._openMoveSceenFlag = this._openMoveSceen;
                }
                KeyCode.resetCurKey();
            }
        }
        int n3 = n = _isInCity ? 0 : 50;
        if (this._openMoveSceen) {
            this._camX = Math.min(this._camX, this.getWidth() - 240 - 1);
            this._camX = Math.max(this._camX, 0);
            this._camY = Math.min(this._camY, this.getHeight() - (320 - n) - 1);
            this._camY = Math.max(this._camY, 0);
            this._camX <<= 10;
            this._camY <<= 10;
            Scene.setCamera(this._camX, this._camY);
            this._camY >>= 10;
            this._camX >>= 10;
            if (SceneUI.getInstance().isCountDownZero()) {
                this._openMoveSceen = false;
                this._openMoveSceenFlag = false;
            }
        }
    }

    public boolean isCameraStop() {
        return _preCamX == _camx && _preCamY == _camy;
    }

    public void dispose() {
        int n;
        this._bk.dispose();
        this._bk = null;
        int n2 = 0;
        while (n2 < _activeInsts.length) {
            Scene._activeInsts[n2] = null;
            ++n2;
        }
        _activeInsts = null;
        int n3 = 0;
        while (n3 < _insts.length) {
            Scene._insts[n3] = null;
            ++n3;
        }
        _insts = null;
        int n4 = 0;
        while (n4 < _actorPool.length) {
            if (_actorPool[n4] != null) {
                n = 0;
                while (n < _actorPool[n4].length) {
                    Scene._actorPool[n4][n] = null;
                    ++n;
                }
                Scene._actorPool[n4] = null;
            }
            ++n4;
        }
        n = 0;
        while (n < _sectorCaptorId.length) {
            Scene._sectorCaptorId[n] = null;
            ++n;
        }
        _sectorCaptorId = null;
        int n5 = 0;
        while (n5 < _sectorActorId.length) {
            Scene._sectorActorId[n5] = null;
            ++n5;
        }
        _sectorActorId = null;
        int n6 = 0;
        while (n6 < _actorInitData.length) {
            Scene._actorInitData[n6] = null;
            ++n6;
        }
        _actorInitData = null;
        int n7 = 0;
        while (n7 < _captorInitData.length) {
            Scene._captorInitData[n7] = null;
            ++n7;
        }
        _captorInitData = null;
        _captorInstTriged = null;
        _actorInstInited = null;
        _globalActorId = null;
    }

    public final void disActiveInst(int n) {
        if (_activeInsts[n] == null) {
            return;
        }
        Scene._activeInsts[n]._active = false;
        Scene._activeInsts[n] = null;
    }

    private final void checkCaptor(byte by) throws IOException {
        int n = R.readIntCaptor(_captorInitData[by], 14, 2);
        int n2 = R.readIntCaptor(_captorInitData[by], 16, 2);
        int n3 = R.readIntCaptor(_captorInitData[by], 18, 2);
        int n4 = R.readIntCaptor(_captorInitData[by], 20, 2);
        Actor actor = this.getFocusActor();
        if (actor.collide(n, n2, n3, n4) && !_captorInstTriged[by]) {
            this.triggerCaptor(by);
        }
    }

    public final void triggerCaptor(int n) throws IOException {
        int n2 = R.readIntCaptor(_captorInitData[n], 0, 1);
        Scene._captorInstTriged[n] = true;
        switch (n2) {
            case 1: {
                int n3 = R.readIntCaptor(_captorInitData[n], 22, 1) & 0xFF;
                if (!this.isScriptEnd()) break;
                this.doScript(n3, -1);
                break;
            }
        }
    }

    public Actor fetchActorFromPool(int n, int n2) {
        Actor actor = null;
        if (n < 0) {
            n = _actorInitData[n2][0];
        }
        int n3 = 0;
        while (n3 < _actorPool[n].length) {
            actor = _actorPool[n][n3];
            if (!actor._active) break;
            ++n3;
        }
        if (n3 < _actorPool[n].length) {
            if (n2 >= 0) {
                if (!_actorInstInited[n2]) {
                    Scene._activeInsts[n2] = actor.activate(this, n2);
                    _activeInsts[n2].init(_actorInitData[n2]);
                    return actor;
                }
            } else {
                int n4 = _staticActorNum;
                while (n4 < _activeInsts.length) {
                    if (_activeInsts[n4] == null) {
                        Scene._activeInsts[n4] = actor.activate(this, n4);
                        _activeInsts[n4].init(0, 0, 0);
                        return actor;
                    }
                    ++n4;
                }
            }
        }
        return null;
    }

    public static void setFocusActor(Actor actor) {
        _focus = actor;
    }

    public static void setCamera(int n, int n2) {
        _camx = n;
        _camy = n2;
    }

    public final Actor getFocusActor() {
        return _focus;
    }

    public final int getWidth() {
        return this._bk.getWidth();
    }

    public final int getHeight() {
        return this._bk.getHeight();
    }

    public final GameMainLogic getGameLogic() {
        return this._gic;
    }

    public void changeNextScenePos(int n, int n2) {
        _nextCol = n;
        _nextRow = n2;
        _nextAction = _focus.getCurAction();
    }

    public void resetPos() {
        _nextCol = -1;
        _nextRow = -1;
        _nextAction = -1;
    }

    public boolean isChangePos() {
        return _nextCol != -1 || _nextRow != -1;
    }

    public void changeState(byte by) {
        _state = by;
    }

    public void lockCamera(int n, int n2) {
        this._lockCameraXpos = n;
        this._lockCameraYpos = n2;
        this._isLockedCamera = true;
    }

    public boolean isLockCamera() {
        return this._isLockedCamera;
    }

    public void unlockCamera() {
        _camw = 245760;
        _camh = 327680;
        this._isLockedCamera = false;
    }

    public final boolean isStableCamera(int n, int n2) {
        int n3 = _camx >> 10;
        int n4 = _camy >> 10;
        int n5 = this._lockCameraXpos >> 10;
        int n6 = this._lockCameraYpos >> 10;
        int n7 = _isInCity ? 0 : 50;
        n5 = Math.min(n5, n - 240 - 1);
        n5 = Math.max(n5, 0);
        n6 = Math.min(n6, n2 - (320 - n7) - 1);
        n6 = Math.max(n6, 0);
        return n3 == n5 && n4 == n6;
    }

    public void startUpShake(int n, int n2) {
        this._shakeRange = n;
        this._shakeTime = n2;
    }

    public void paintEffect(Graphics graphics) {
        if (Function.isDrawBlack()) {
            Function.drawBlack(graphics);
        }
        if (Function.isDrawFlash()) {
            Function.drawFlash(graphics);
        }
    }

    public void clearShake() {
        this._shakeTime = -1;
        this._cameraOffsetX = 0;
        this._cameraOffsetY = 0;
    }

    public void updateCameraOffset() {
        if (this._shakeTime >= 0x3FFFFFFF) {
            this._shakeTime = -1;
        }
        if (this._shakeTime >= 0) {
            int n = this._shakeTime % 6;
            switch (n) {
                case 0: {
                    this._cameraOffsetX = -this._shakeRange;
                    this._cameraOffsetY = -this._shakeRange;
                    break;
                }
                case 1: {
                    this._cameraOffsetX = this._shakeRange;
                    this._cameraOffsetY = this._shakeRange;
                    break;
                }
                case 2: {
                    this._cameraOffsetX = 0;
                    this._cameraOffsetY = 0;
                    break;
                }
                case 3: {
                    this._cameraOffsetX = this._shakeRange;
                    this._cameraOffsetY = -this._shakeRange;
                    break;
                }
                case 4: {
                    this._cameraOffsetX = -this._shakeRange;
                    this._cameraOffsetY = this._shakeRange;
                    break;
                }
                case 5: {
                    this._cameraOffsetX = 0;
                    this._cameraOffsetY = 0;
                }
            }
            --this._shakeTime;
        } else {
            this.clearShake();
        }
    }

    public final void setDialogInfo(String string, String string2, int n, int n2) {
        this._messageBox = GameMessageBox.getInstance(this);
        this._messageBox.initDialogStyle(n, n2, string, string2);
    }

    public void initPlayMovie(int n, int n2, int n3, int n4) {
        this._effectAni = _resource.loadAvatar(n, 1);
        this._isPlayAni = true;
        this._effectAniX = n2;
        this._effectAniY = n3;
        this._effectAniAction = n4;
        this._flightFram = 0;
    }

    public void drawPlayMovie(Graphics graphics) {
        if (this._isPlayAni) {
            this._effectAni.draw(graphics, this._effectAniX, this._effectAniY, this._effectAniAction, this._flightFram, 0);
            if (++this._flightFram > this._effectAni.getActFrmNum(this._effectAniAction) - 1) {
                this._isPlayAni = false;
            }
        }
    }

    private void intStyleShowString(String string) {
        this._contextString = string;
        this._rollEnd = false;
        this._rollStart = true;
        Function._speed = Function.C_WORD_H;
    }

    private void drawShowString(Graphics graphics) {
        if (this._rollStart) {
            Function.drawBackGroud(graphics, 0, 0, 240, 320);
            if (Function.drawRollString(graphics, this._contextString, 20, 106, 106, 3653543)) {
                this._rollEnd = true;
                this._rollStart = false;
            }
            this.updataShowString();
        }
    }

    private void updataShowString() {
        int n = KeyCode.getCurKey();
        if (n == 16) {
            Function._speed += 10;
            KeyCode.resetCurKey();
        }
    }

    public int getActorId(int n) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < _activeInsts.length) {
            if (_activeInsts[n3] != null && Scene._activeInsts[n3]._id == n) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        return n2;
    }

    public void changeMapShow(int n) {
        GameInterface._mapFlag[n] = true;
    }

    public void finishHandle() {
        this._messageBox = null;
    }

    public boolean s2n_moveActor(int n, int n2, int n3, int n4) {
        int n5 = 10 * this._bk.getTileWidth();
        int n6 = 10 * this._bk.getTileHeigth();
        n5 <<= 10;
        n6 <<= 10;
        int n7 = this.getActorId(n);
        switch (n4) {
            case 0: {
                if (!Scene._activeInsts[n7]._isScriptEnd) {
                    Scene._activeInsts[n7]._isScriptEnd = true;
                    _activeInsts[n7].lrWalk(n2, n3);
                    return false;
                }
                if (Scene._activeInsts[n7]._isScriptEnd && _activeInsts[n7].isArrivd()) {
                    Scene._activeInsts[n7]._isScriptEnd = false;
                    if (_isInCity) {
                        this.setFollow();
                    }
                    return true;
                }
                return false;
            }
            case 1: {
                if (_activeInsts[n7] != null) {
                    Scene._activeInsts[n7]._x = n5;
                    Scene._activeInsts[n7]._y = n6;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean s2n_actionActor(int n, int n2) {
        if ((n = this.getActorId(n)) == -1) {
            return false;
        }
        if (_activeInsts[n] != null) {
            _activeInsts[n].changeAction(n2);
            _activeInsts[n].setActorInfo(n2, Scene._activeInsts[n]._x, Scene._activeInsts[n]._y);
            ActorInfo.recordSceneActorID(Scene._activeInsts[n]._id, _activeInsts[n].getCurActorInfo(), this.getGameLogic().getLevel());
            return true;
        }
        return false;
    }

    public boolean s2n_ai(int n, int n2, int n3) {
        if (n3 == 0) {
            int n4 = 0;
            while (n4 < _activeInsts.length) {
                if (_activeInsts[n4] != null) {
                    _activeInsts[n4].setAI(n > 0);
                }
                ++n4;
            }
        }
        KeyCode.resetCurKey();
        return true;
    }

    public boolean s2n_moveScreen(int n, int n2, int n3) {
        int n4;
        int n5;
        if (n2 < 0 && n3 < 0) {
            n5 = _camx;
            n4 = _camy;
        } else {
            n5 = n2 * this._bk.getTileWidth();
            n4 = n3 * this._bk.getTileHeigth();
            n5 <<= 10;
            n4 <<= 10;
        }
        this.lockCamera(n5, n4);
        return this.isStableCamera(this._bk.getWidth(), this._bk.getHeight());
    }

    public boolean s2n_unlockScreen() {
        this.unlockCamera();
        return this.endChangeFocus();
    }

    public boolean s2n_task(int n, int n2, int n3, int n4, int n5) {
        RoleTeamData.getInstance().consumeTask(n, n2);
        return true;
    }

    public boolean s2n_dialog(int n, String string, String string2) {
        if (n == 101) {
            if (!this._openTeach) {
                this._openTeach = true;
                GameMainLogic._interface.getGameUI().teachingDialog(string2);
                return false;
            }
            this._openTeach = false;
            return true;
        }
        if (n == 102) {
            if (!this._openSceneTeach && !this._isScriptEnd) {
                this._openSceneTeach = true;
                SceneUI.getInstance().teachingDialog(string2);
                return false;
            }
            if (this._openSceneTeach && this._isScriptEnd) {
                this._openSceneTeach = false;
                this._isScriptEnd = false;
                return true;
            }
        } else {
            int n2 = 0;
            n = this.getActorId(n);
            n2 = Scene._activeInsts[n]._type == 39 || Scene._activeInsts[n]._type == 41 ? 87 : 62;
            if (this.isLockCamera()) {
                this.unlockCamera();
            }
            if (!this._isScriptEnd && this._messageBox == null && this.endChangeFocus()) {
                int n3 = _activeInsts[n].getXSceen(_camx) >> 10;
                int n4 = Math.abs(_activeInsts[n].getYSceen(_camy) >> 10) - n2;
                this._isScriptEnd = true;
                this.setDialogInfo(string, string2, n3, n4);
            }
            if (this._isScriptEnd && this._messageBox == null) {
                this._isScriptEnd = false;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean s2n_removeActor(int n, int n2) {
        return true;
    }

    public int s2n_makeActor(int n, int n2, int n3, int n4, int n5) {
        return 0;
    }

    public boolean s2n_makeGroupActor(int n, int n2, int n3, int n4, int n5) {
        return false;
    }

    public boolean s2n_passLevel(int n, int n2, int n3, int n4) {
        this.setFollow();
        GameMainLogic._interface.changeLevel(n, n2, n3);
        return true;
    }

    public boolean s2n_message(int n, int n2, String string) {
        switch (n) {
            case 0: {
                if (!this._isScriptEnd && this._messageBox == null) {
                    this._isScriptEnd = true;
                    this._messageBox = GameMessageBox.getInstance(this);
                    this._messageBox.initSinglePageStyle(0, 0, string, 20);
                    return false;
                }
                if (this._isScriptEnd && this._messageBox == null) {
                    this._isScriptEnd = false;
                    return true;
                }
                return false;
            }
            case 1: {
                if (!this._isScriptEnd && !this._rollEnd) {
                    this._isScriptEnd = true;
                    this.intStyleShowString(string);
                    return false;
                }
                if (this._isScriptEnd && this._rollEnd) {
                    this._isScriptEnd = false;
                    this._rollEnd = false;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean s2n_userDefined(int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 0: {
                GameMainLogic._gameScenario = n2;
                return true;
            }
            case 1: {
                if (this._flightFram == 0 && !this._isPlayAni) {
                    this.initPlayMovie(n2, n3, n4, n5);
                    return false;
                }
                if (this._flightFram != 0 && !this._isPlayAni) {
                    this._flightFram = 0;
                    return true;
                }
                return false;
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        RoleTeamData.getInstance().addMember(n3);
                        if (_isInCity) {
                            this.setFollow();
                        }
                        return true;
                    }
                    case 1: {
                        RoleTeamData.getInstance().delMember(n3);
                        return true;
                    }
                }
                return false;
            }
            case 3: {
                switch (n2) {
                    case 0: {
                        RoleTeamData.getInstance().consumeTool(n3, n4);
                        SceneUI.getInstance().toolMenuInfo();
                        return true;
                    }
                    case 1: {
                        RoleTeamData.getInstance().consumeEquip(n3, n4);
                        return true;
                    }
                    case 2: {
                        RoleTeamData.getInstance().consumeWeapon(n3, n4);
                        return true;
                    }
                    case 3: {
                        RoleTeamData.getInstance().consumeBomb(n3, n4);
                        return true;
                    }
                    case 4: {
                        RoleTeamData.getInstance().consumeTask(n3, n4);
                        DataTable dataTable = GameDB.getGameDataBase().getData(6, n3);
                        int[] nArray = dataTable.getArrayItem(6);
                        int n6 = 1;
                        while (n6 < nArray.length) {
                            RoleTeamData.getInstance().consumeKill(nArray[n6 - 1], 0, n4 > 0 ? nArray[n6] : -nArray[n6]);
                            n6 += 2;
                        }
                        return true;
                    }
                }
                return false;
            }
            case 4: {
                if (this._openShop) {
                    this._openShop = false;
                    return true;
                }
                this._gic.changeState((byte)0);
                GameMainLogic._interface.changeState((byte)19);
                GameMainLogic._interface.getGameUI().setShopKind(n2);
                GameMainLogic._interface.getGameUI().init(2);
                return false;
            }
            case 5: {
                if (this._openShop) {
                    this._openShop = false;
                    return true;
                }
                this._gic.changeState((byte)0);
                GameMainLogic._interface.changeState((byte)19);
                GameMainLogic._interface.getGameUI().setTaskMan(n2);
                GameMainLogic._interface.getGameUI().init(1);
                return false;
            }
            case 6: {
                if (!this._isScriptEnd && this._messageBox == null) {
                    this._isScriptEnd = true;
                    this._messageBox = GameMessageBox.getInstance(this);
                    this._messageBox.initShopStyle(0, null);
                }
                if (this._isScriptEnd && this._messageBox == null) {
                    this._isScriptEnd = false;
                    return true;
                }
                return false;
            }
            case 7: {
                if (n2 == 0) {
                    RoleTeamData.getInstance().consumeMoney(n3);
                }
                if (n2 == 1) {
                    ((MainActor)_focus).fullHp();
                }
                return true;
            }
            case 8: {
                this.changeMapShow(n2);
                return true;
            }
            case 9: {
                if (this._openTeach) {
                    this._openTeach = false;
                    return true;
                }
                this._gic.changeState((byte)0);
                GameMainLogic._interface.changeState((byte)19);
                GameMainLogic._interface.getGameUI().teaching(n2, n3, n4, n5);
                this._openTeach = true;
                return false;
            }
            case 10: {
                GameMainLogic._interface.getGameUI().teachingExit();
                return true;
            }
            case 12: {
                SceneUI.getInstance().teaching(n2, n3);
                return true;
            }
            case 11: {
                if (!this._openSceneTeach && !this._isScriptEnd) {
                    if (n2 != 1) {
                        this._openSceneTeach = true;
                        int n7 = 0;
                        while (n7 < _activeInsts.length) {
                            if (_activeInsts[n7] != null) {
                                _activeInsts[n7].setAI(false);
                            }
                            ++n7;
                        }
                        this.setPressKey(n2, n3);
                        if (n2 == 0) {
                            this.initKeyPos(210, 65, 2);
                        }
                        if (n2 == 6) {
                            this.initKeyPos(110, 260, 3);
                        }
                    } else {
                        this.setPressKey(n2, n3);
                        return true;
                    }
                    return false;
                }
                if (this._openSceneTeach && this._isScriptEnd) {
                    this._openSceneTeach = false;
                    this._isScriptEnd = false;
                    this.closeSceneTeachTwo();
                    return true;
                }
                return false;
            }
            case 13: {
                if (!this._openSceneTeach && !this._isScriptEnd) {
                    this._openSceneTeach = true;
                    SceneUI.getInstance().toolTeaching(n2);
                } else if (this._openSceneTeach && this._isScriptEnd && ((MainActor)_focus).isCommonState()) {
                    this._openSceneTeach = false;
                    this._isScriptEnd = false;
                    this.closeSceneTeachTwo();
                    return true;
                }
                return false;
            }
            case 14: {
                if (!this._openSceneTeach && !this._isScriptEnd) {
                    this._openSceneTeach = true;
                    int n8 = 0;
                    while (n8 < _activeInsts.length) {
                        if (_activeInsts[n8] != null) {
                            _activeInsts[n8].setAI(false);
                        }
                        ++n8;
                    }
                    ((MainActor)_focus).teachinfo(n2, n3);
                } else if (this._openSceneTeach && this._isScriptEnd) {
                    this._bk.operateBlackScreen(false);
                    this._openSceneTeach = false;
                    this.closeSceneTeachTwo();
                    this._isScriptEnd = false;
                    return true;
                }
                return false;
            }
            case 15: {
                if (!this._openFace && !this._isScriptEnd) {
                    this._openFace = true;
                    n2 = this.getActorId(n2);
                    this._openFaceX = _activeInsts[n2].getXSceen(_camx) >> 10;
                    this._openFaceY = _activeInsts[n2].getYSceen(_camy) >> 10;
                    this._openFaceId = n3;
                } else if (this._openFace && this._isScriptEnd) {
                    this._openFace = false;
                    this.closeSceneTeachTwo();
                    this._isScriptEnd = false;
                    return true;
                }
                return false;
            }
            case 16: {
                this.changeEquip(n2, n3, n4);
                return true;
            }
            case 17: {
                if (!this._isScriptEnd && this._messageBox == null) {
                    this._isScriptEnd = true;
                    this._messageBox = GameMessageBox.getInstance(this);
                    this._messageBox.initSinglePageStyle(0, 0, "K\u1ebft th\u00fac", 20);
                    return false;
                }
                if (this._isScriptEnd && this._messageBox == null) {
                    GameMainLogic._interface.setInMenuState(false);
                    this.resetPos();
                    this.getGameLogic().changeState((byte)0);
                    this.getGameLogic();
                    GameMainLogic._interface.changeState((byte)4);
                    Function.changeSoundState(Function.getSceneSoundId(0), -1);
                    this._isScriptEnd = false;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private void initKeyPos(int n, int n2, int n3) {
        this._openMoveFlag = true;
        this._openFlagX = n;
        this._openFlagY = n2;
        this._openFlagAction = n3;
        this._effectAni = _resource.loadAvatar(81, 1);
    }

    private void changeEquip(int n, int n2, int n3) {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        GameRoleData gameRoleData = RoleTeamData.getInstance().getRoleData(n);
        int n4 = gameRoleData.getIntoEquip(n2, n3);
        switch (n2) {
            case 4: {
                roleTeamData.consumeWeapon(n4, 1);
            }
        }
    }

    public int s2n_getIfLeftValue(String string, int n) {
        if (string.compareTo("0") == 0) {
            return GameMainLogic._gameScenario;
        }
        if (string.compareTo("1") == 0) {
            this.checkTaskState();
            return GameMainLogic._gameTaskState;
        }
        if (string.compareTo("2") == 0) {
            if (GameMainLogic._gameTaskState == 1) {
                return this.checkTaskIndex(n);
            }
            return GameMainLogic._gameTaskIndex;
        }
        return 0;
    }

    public boolean s2n_saveDoc(int n) {
        return false;
    }

    public boolean s2n_playSound(int n) {
        return true;
    }

    public boolean s2n_stopSound() {
        return true;
    }

    public boolean s2n_weather(int n) {
        return false;
    }

    public boolean s2n_screenEffect(int n, int n2, int n3, int n4) {
        switch (n) {
            case 0: {
                if (n2 == 0) {
                    Function.openBlack();
                } else {
                    Function.closeBlack();
                }
                return true;
            }
            case 1: {
                Function.initFlash(n2);
                return true;
            }
            case 2: {
                this.startUpShake(n2, n3);
                return true;
            }
        }
        return true;
    }

    public boolean s2n_pressKey(int n) {
        return false;
    }

    public boolean s2n_setFocus(int n) {
        if ((n = this.getActorId(n)) == -1) {
            return false;
        }
        if (!this._isScriptEnd && _activeInsts[n] != null) {
            this._isScriptEnd = true;
            this._isLockedCamera = false;
            Scene.setFocusActor(_activeInsts[n]);
        }
        if (this._isScriptEnd && this.endChangeFocus()) {
            this._isScriptEnd = false;
            return true;
        }
        return false;
    }

    public boolean s2n_get(int n, int n2) {
        return false;
    }

    public Object s2n_getKeyValue(String string) {
        return null;
    }

    public void resultHandle(int n) {
    }

    public void cancelHandle() {
    }

    public void shopResultHandle(int n) {
    }

    public void closeGameUI() {
        this._openShop = true;
    }

    public void closeSceneTeachOne() {
        this._isScriptEnd = true;
        this._openMoveFlag = false;
        this._pressKey = -1;
        _bombState = 0;
    }

    public void closeSceneTeachTwo() {
        int n = 0;
        while (n < _activeInsts.length) {
            if (_activeInsts[n] != null) {
                _activeInsts[n].setAI(true);
            }
            ++n;
        }
        _focus.changeToWait();
    }

    public boolean getceneTeach() {
        return this._openSceneTeach;
    }

    public void setPressKey(int n, int n2) {
        this._pressKey = n;
        this._moveValue = n2;
        if (n == 1) {
            ((MainActor)Scene._focus)._mainActorInfo[2] = n2;
        }
    }

    public int getMoveValue() {
        return this._moveValue;
    }

    public int getPressKey() {
        return this._pressKey;
    }

    public final void save(DataOutputStream dataOutputStream) {
        try {
            int n = 0;
            while (n < _activeInsts.length) {
                if (_activeInsts[n] != null && (Scene._activeInsts[n]._type == 0 || Scene._activeInsts[n]._type == 1 || Scene._activeInsts[n]._type == 2)) {
                    _activeInsts[n].setActorInfo(Scene._activeInsts[n]._curAction, Scene._activeInsts[n]._x, Scene._activeInsts[n]._y);
                    ActorInfo.recordSceneActorID(Scene._activeInsts[n]._id, _activeInsts[n].getCurActorInfo(), this.getGameLogic().getLevel());
                }
                ++n;
            }
            ActorInfo.saveActorAction(dataOutputStream);
            dataOutputStream.writeShort(GameMainLogic._gameScenario);
            int n2 = 0;
            while (n2 < GameInterface._mapFlag.length) {
                dataOutputStream.writeBoolean(GameInterface._mapFlag[n2]);
                ++n2;
            }
            RoleTeamData.getInstance().save(dataOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void load(DataInputStream dataInputStream) {
        try {
            this._isReadRMS = true;
            ActorInfo.loadActorAction(dataInputStream);
            GameMainLogic._gameScenario = dataInputStream.readShort();
            int n = 0;
            while (n < GameInterface._mapFlag.length) {
                GameInterface._mapFlag[n] = dataInputStream.readBoolean();
                ++n;
            }
            RoleTeamData.getInstance().load(dataInputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkTaskState() {
        int n;
        GameDB gameDB = GameDB.getGameDataBase();
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        boolean[] blArray = roleTeamData.getPackageExist(4);
        int[] nArray = gameDB.getData(1, GameMainLogic._gameTaskMan).getArrayItem(12);
        int n2 = 0;
        while (n2 < nArray.length) {
            if (blArray[nArray[n2]]) {
                int[] nArray2 = gameDB.getData(6, nArray[n2]).getArrayItem(6);
                int[] nArray3 = gameDB.getData(6, nArray[n2]).getArrayItem(7);
                int[] nArray4 = roleTeamData.getPackageInfo(5);
                int[] nArray5 = roleTeamData.getPackageInfo(3);
                n = 1;
                while (n < nArray2.length) {
                    if (nArray4[nArray2[n - 1]] < nArray2[n]) break;
                    n += 2;
                }
                if (n >= nArray2.length) {
                    n = 1;
                    while (n < nArray3.length) {
                        if (nArray5[nArray3[n - 1]] < nArray3[n]) break;
                        n += 2;
                    }
                    if (n >= nArray3.length) {
                        GameMainLogic._gameTaskState = 1;
                        return;
                    }
                }
            }
            ++n2;
        }
        n = roleTeamData.getRoleData(0).getRoleInx()[1];
        int n3 = 0;
        while (n3 < nArray.length) {
            DataTable dataTable = gameDB.getData(6, nArray[n3]);
            if (dataTable.getIntItem(4) <= n && !blArray[nArray[n3]]) {
                GameMainLogic._gameTaskState = 0;
                return;
            }
            ++n3;
        }
        GameMainLogic._gameTaskState = 2;
    }

    private int checkTaskIndex(int n) {
        GameDB gameDB = GameDB.getGameDataBase();
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        boolean[] blArray = roleTeamData.getPackageExist(4);
        if (!blArray[n]) {
            return -1;
        }
        int[] nArray = gameDB.getData(6, n).getArrayItem(6);
        int[] nArray2 = gameDB.getData(6, n).getArrayItem(7);
        int[] nArray3 = roleTeamData.getPackageInfo(5);
        int[] nArray4 = roleTeamData.getPackageInfo(3);
        int n2 = 1;
        while (n2 < nArray.length) {
            if (nArray3[nArray[n2 - 1]] < nArray[n2]) break;
            n2 += 2;
        }
        if (n2 < nArray.length) {
            n = -1;
        }
        n2 = 1;
        while (n2 < nArray2.length) {
            if (nArray4[nArray2[n2 - 1]] < nArray2[n2]) break;
            n2 += 2;
        }
        if (n2 < nArray2.length) {
            n = -1;
        }
        return n;
    }

    public boolean isFinishCurTask(int n) {
        return this.checkTaskIndex(n) == n;
    }

    static {
        _actorExistFlag = new int[4][7];
        _mainActor = new MainActor[7];
        MOVE_SCEEN_DATA = new int[][]{{110, 35, 4}, {110, 245, 8}, {10, 122, 1}, {230, 122, 2}};
        MOVE_SCEEN_ACTION = new int[][]{{19, 20}, {1073741843, 0x40000014}, {21, 22}, {-2147483627, -2147483626}};
        TOUCH_SCEEN_KEY = new int[][]{{2, 8}, {5, 11}, {0, 6}, {3, 9}, {1, 7}, {4, 10}};
        TOUCH_KEY_DATA = new int[][]{{0, 140, 512}, {0, 160, 256}, {0, 180, 1024}, {220, 140, 4096}, {220, 160, 32768}, {220, 180, 131072}};
        _tankNum = 0;
        _tankOneTeamNum = 0;
        _tankTwoTeamNum = 0;
        _scriptSave = new byte[80];
        _anims = new Avatar[101];
        _actorPool = new Actor[101][];
        _typesLoad = new byte[101][2];
        _newIds = new byte[40];
        _nextCol = -1;
        _nextRow = -1;
        _nextAction = -1;
    }
}

